//=============================================================================
// ShockProjectile.
//=============================================================================
class LighteningProjectile extends Projectile;


var Vector LastLoc;
var Pawn Seeking;
var Sound megaSplatSound;
var int amountGibs;


simulated event PreBeginPlay()
{
    Super.PreBeginPlay();

    if( Pawn(Owner) != None )
        Instigator = Pawn( Owner );
    Velocity = Speed * Vector(Rotation); // starts off slower so combo can be done closer

}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

    LastLoc = Location;
    SetTimer(0.05,true);
}

simulated function Timer()
{
    local xEmitter arc;
    local Vector newLoc;
    local Pawn SearchVictim;
    arc=Spawn(class'MiniLightningBolt',,,LastLoc);
    newLoc=Location+VRand()*32;
    arc.mSpawnVecA = NewLoc;
    LastLoc = newLoc;

    if(Seeking != None)
      if((vSize(Seeking.Location - Location)>300) || (Seeking.Health <= 0))
        Seeking = None;

    if(Seeking == None)
      ForEach RadiusActors(class'Pawn', SearchVictim, 256)
        if((SearchVictim != Instigator) && (SearchVictim.Health>0))// && (Level.Game.ReduceDamage(20, SearchVictim, instigator, SearchVictim.Location, Velocity, MyDamageType) != 0))
          Seeking=SearchVictim;

//    if(Seeking != None)
//      Velocity = Speed * Normal(Normal(Seeking.Location - Location) * 0.5 * Speed + Velocity);
    if(Seeking != None)
      Velocity=2*Normal(Seeking.Location - Location)+Normal(Velocity);
      Velocity=Speed*Normal(Velocity);
}

function MegaSplat(pawn Victim){

//  if (level.netmode == nm_dedicatedserver)
//   log("MegaSplat: This is the dedicated server");

//  if (level.netmode == nm_client)
//   log("MegaSplat: This is the client");
  if(Level.Game.ReduceDamage(20, Victim, instigator, location, Velocity, MyDamageType) == 0)
    return;
  Spawn(class'MegaSplatHelper', Victim,,victim.location);
  Victim.died(Instigator.Controller, MyDamageType, Victim.Location);

  return;
}


simulated function PostNetBeginPlay()
{
	local PlayerController PC;
	
	Super.PostNetBeginPlay();
	
	if ( Level.NetMode == NM_DedicatedServer )
		return;
		
	PC = Level.GetLocalPlayerController();
	if ( (Instigator != None) && (PC == Instigator.Controller) )
		return;
}


simulated singular function HitWall(vector HitNormal, actor Wall){

    Spawn(Class'xEffects.WallSparks',self,,Location, Rotator(-HitNormal));

    // electricity shouldn't harm vehicles, since they're mostly faraday cages

    if (vehicle(wall) != none) return;

    Super.HitWall(HitNormal, Wall);
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
//    local Vector X, RefNormal, RefDir;

  if (level.netmode == nm_dedicatedserver)
   log("ProcessTouch: This is the dedicated server");

  if (level.netmode == nm_client)
   log("ProcessTouch: This is the client");


    if (Other == Instigator) return;
    if (Other == Owner) return;

    // lightning hitting each other cancels out
    if (Other.isa('LighteningProjectile'))
    {
     spawn(class'xEffects.childBlueSparks',,,hitLocation,);
     destroy();
     other.destroy();
     return;
    }

    // vehicles act as faraday cages, so are safe from the lightning.
    if (other.isa('Vehicle'))
    {
     return;
    }


    if (Other.IsA('Pawn') && (Pawn(Other).Health>0))// && (Level.Game.ReduceDamage(20, pawn(other), instigator, HitLocation, Velocity, MyDamageType) != 0))
    {
      log("Hit a victim! Health: "$Pawn(Other).Health);
      if(Pawn(Other).Health>30)
        Pawn(Other).TakeDamage(damage, Instigator, Location, Velocity, MyDamageType);
      else
        MegaSplat(Pawn(Other));
    }



}

simulated function Explode(vector HitLocation,vector HitNormal)
{
//    if ( Role == ROLE_Authority )
//    {
//        HurtRadius(Damage, DamageRadius, MyDamageType, MomentumTransfer, HitLocation );
//    }

    SetCollisionSize(0.0, 0.0);
	Destroy();
}

Simulated function Destroyed(){
    Spawn(class'MiniLightningBolt',,,LastLoc).mSpawnVecA = Location;

    Super.Destroyed();
}

defaultproperties
{
     megaSplatSound=Sound'CicadaSnds.Decoy.DecoyLaunch'
     amountGibs=41
     Speed=4096.000000
     MaxSpeed=4096.000000
     bSwitchToZeroCollision=True
     Damage=10.000000
     DamageRadius=150.000000
     MomentumTransfer=50000.000000
     MyDamageType=Class'GSSAL.DamTypeGSSALLightning'
     ExplosionDecal=Class'XEffects.ShockImpactScorch'
     MaxEffectDistance=7000.000000
     DrawType=DT_None
     CullDistance=4000.000000
     bNetTemporary=False
     AmbientSound=Sound'IndoorAmbience.electricity1'
     LifeSpan=0.250000
     FluidSurfaceShootStrengthMod=8.000000
     SoundVolume=128
     SoundRadius=200.000000
     CollisionRadius=20.000000
     CollisionHeight=20.000000
     ForceType=FT_Constant
     ForceRadius=40.000000
     ForceScale=5.000000
}
