Class ThunderbirdBomb extends Projectile;


var vector initialDir;
var Controller ResponsibleController;


simulated function PostBeginPlay()
{
	local Rotator R;

	Super.PostBeginPlay();
	R = Rotation;
	R.Roll = Rand(32000);
	R.Pitch = Rand(32000);
	R.Yaw = Rand(32000);
	RotationRate=R;
        SetRotation(R);
    responsibleController=pawn(owner).Controller;
    Instigator=pawn(owner);

}



simulated function ProcessTouch(Actor Other, Vector HitLocation)
{
	if ( Other != Instigator )
	{
		Explode(HitLocation,Normal(HitLocation-Other.Location));
	}
}


simulated function Landed( vector HitNormal )
{
	Explode(Location,HitNormal);
}

simulated function HitWall (vector HitNormal, actor Wall)
{
	Landed(HitNormal);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
//    local vector start;
    local rotator rot;
    local int i;

//	start = Location + 10 * HitNormal;
	if ( Role == ROLE_Authority )
	{
	Spawn( class 'ThunderBirdDeathBomb',ResponsibleController, '', HitLocation+(100*HitNormal)).ResponsibleController=ResponsibleController;

		for (i=0; i<6; i++)
		{
			rot = Rotator(HitNormal);
			rot.yaw += FRand()*16000-8000;
			rot.pitch += FRand()*16000-8000;
			rot.roll += FRand()*16000-8000;
			Spawn( class 'ThunderBirdBomblet',ResponsibleController, '', HitLocation+(100*HitNormal), rot).ResponsibleController=ResponsibleController;
		}
	}
    Destroy();
}

defaultproperties
{
     TossZ=225.000000
     Damage=90.000000
     MyDamageType=Class'XWeapons.DamTypeFlakShell'
     ExplosionDecal=Class'XEffects.ShockAltDecal'
     DrawType=DT_StaticMesh
     StaticMesh=StaticMesh'WeaponStaticMesh.FlakShell'
     CullDistance=16000.000000
     Physics=PHYS_Falling
     LifeSpan=12.000000
     DrawScale=80.000000
     Skins(0)=Texture'XWeapons.Skins.NewFlakSkin'
     AmbientGlow=100
     SoundVolume=255
     SoundRadius=100.000000
     bProjTarget=True
     ForceType=FT_Constant
     ForceRadius=60.000000
     ForceScale=5.000000
}
