Class ThunderbirdBombLet extends Projectile;


var vector initialDir;

var Controller responsibleController;

simulated function PostBeginPlay()
{
	local Rotator R;

	Super.PostBeginPlay();
	Velocity = Vector(Rotation) * Speed;  
	R = Rotation;
	R.Roll = 32768;
	SetRotation(R);
	Velocity.z += TossZ; 
	initialDir = Velocity;
}


simulated function ProcessTouch(Actor Other, Vector HitLocation)
{
	if ( Other != Instigator )
	{
		Explode(HitLocation,Normal(HitLocation-Other.Location));
	}
}


simulated function Landed( vector HitNormal )
{
	Explode(Location,HitNormal);
}

simulated function HitWall (vector HitNormal, actor Wall)
{
	Landed(HitNormal);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
    local vector start;
    local rotator rot;

	start = Location + 10 * HitNormal;
	if ( Role == ROLE_Authority )
	{
	Spawn( class 'ThunderBirdDeathBomb',Owner, '', HitLocation+(100*HitNormal), rot);

		if(Rand(100)>70)
		{
			rot = Rotator(HitNormal);
			rot.yaw += FRand()*16000-8000;
			rot.pitch += FRand()*16000-8000;
			rot.roll += FRand()*16000-8000;
			Spawn( class 'ThunderbirdBomblet',Owner, '', HitLocation+(100*HitNormal), rot);
		}
	}
    Destroy();
}

defaultproperties
{
     Speed=3000.000000
     TossZ=225.000000
     Damage=90.000000
     MomentumTransfer=75000.000000
     MyDamageType=Class'XWeapons.DamTypeFlakShell'
     ExplosionDecal=Class'XEffects.ShockAltDecal'
     DrawType=DT_None
     Physics=PHYS_Falling
     AmbientSound=Sound'WeaponSounds.BaseProjectileSounds.BFlakCannonProjectile'
     LifeSpan=12.000000
     DrawScale=80.000000
     Skins(0)=Texture'XWeapons.Skins.NewFlakSkin'
     AmbientGlow=100
     SoundVolume=255
     SoundRadius=100.000000
     bProjTarget=True
     ForceType=FT_Constant
     ForceRadius=60.000000
     ForceScale=5.000000
}
