class RealBang extends Actor;

var() int RemainingVolume;
var RealExplosionVol Bang;

function PostBeginPlay(){
  Enable('Timer');
  SetTimer(0.2, True);
}

function Explode(){
  local int lastiteration;
  PlaySound(Sound'WeaponSounds.BExplosion3');
  Bang=spawn(class'RealExplosionVol', Self, , Location+Vect(0,0, 0));
  do{
    lastiteration=RemainingVolume;
    Bang.Grow();
  }until((RemainingVolume<=0)||(RemainingVolume==lastiteration)) //Grow until either maximum volume reach, or the explosion is determined to be confined.
  Bang.LifeSpan=0.05;
  LifeSpan=10;
}

function Timer(){
  local RealExplosionVol X;  //There may be only one explosion in progress at a time, otherwise there is a risk of crashing.
  foreach AllActors(class'RealExplosionVol', X)
    return;
  Explode();
  Disable('Timer');
  SetTimer(0.0, False);
}

defaultproperties
{
     RemainingVolume=400
     DrawType=DT_None
     RemoteRole=ROLE_None
     LifeSpan=10.000000
}
