class RealExplosionVol extends Actor;

  var RealExplosionVol children[10];
  var byte testcache[10]; //Saves running expensive tests more than once.
  var vector offsets[10];
  var() float gridscale;
  var RealBang manager;
function Destroyed(){
  HurtRadius(150, 256, class'DamTypeFireball', 1000,Location);
  spawn(class'RealExplosionFlames');
}

function Grow(){
  local int n;
  if(manager == None)
    manager=RealBang(Owner);
  if(manager.RemainingVolume<=0)
    return;

  for(n=0; n<10; n++){
    if((testcache[n]==0)&&(Children[n]==none))
      NewExplosionVol(Location+(Offsets[n]*gridscale), n);
    else
      if(children[n]!=none)
        children[n].grow();
  }

}

function NewExplosionVol(Vector newlocation, int n){
  local RealExplosionVol X;
//  local RealBang manager;
//  manager=RealBang(Owner);

  newlocation.X+=rand(64)-32;
  newlocation.Y+=rand(64)-32;
  newlocation.Z+=rand(64)-32;

  if(testcache[n]==0){
    foreach RadiusActors(Class'RealExplosionVol', X, 70*gridscale, newlocation){
      if(X.Owner!=Owner)
        manager.RemainingVolume--;
      testcache[n]=1;
      return;
    }
    if(!FastTrace(Newlocation, Location)){
      testcache[n]=1;
      return;
    }
    manager.RemainingVolume--;
    children[n]=spawn(class'RealExplosionVol', Owner, , newlocation);
    children[n].LifeSpan=LifeSpan+((0.02+(rand(10)*0.015))*vsize(Location-newlocation)/96);
    children[n].gridscale=gridscale;
  }
}


function HurtRadius( float DamageAmount, float DamageRadius, class<DamageType> DamageType, float Momentum, vector HitLocation )
{
	//Differs from the usual HurtRadius in the following ways:
	// - Pawns only. Because fireballs arn't going to break scenery, and are too powerful against Onslaught nodes.
	// - Vehicles and Pawns in vehicles are unaffected.
	// - Tweeked it for performance a little by removing checks not required when confined to pawns.

	local Pawn Victims;
	local float damageScale, dist;
	local vector dir;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Pawn', Victims, DamageRadius, HitLocation )
	{
		if((!Victims.IsA('Vehicle')) && (Victims.Role == ROLE_Authority))
		{
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist;
			damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
			Victims.TakeDamage
			(
				damageScale * DamageAmount,
				Instigator,
				Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
				(damageScale * Momentum * dir),
				DamageType
			);
		}
	}
}

defaultproperties
{
     offsets(0)=(Z=96.000000)
     offsets(1)=(Z=-96.000000)
     offsets(2)=(Y=96.000000)
     offsets(3)=(Y=-96.000000)
     offsets(4)=(X=96.000000)
     offsets(5)=(X=-96.000000)
     offsets(6)=(X=96.000000,Y=96.000000)
     offsets(7)=(X=-96.000000,Y=96.000000)
     offsets(8)=(X=96.000000,Y=-96.000000)
     offsets(9)=(X=-96.000000,Y=-96.000000)
     gridscale=1.000000
     DrawType=DT_None
     RemoteRole=ROLE_None
     LifeSpan=0.001000
}
