//=============================================================================
// ShockProjectile.
//=============================================================================
class MiniTubeMaker extends Projectile;

// the downward offset of the tube (it needs to form under the player's feet)
var float minitubeoffset;

// the pitch of the tube sound (between 1 and 2)
var float tubesoundpitch;
// how much the pitch of the tube sound changes per timer
var float tubesoundpitchbend;

simulated event PreBeginPlay()
{
    Super.PreBeginPlay();

    Velocity = Speed * Vector(Rotation); // starts off slower so combo can be done closer

}

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
      SetTimer(0.5,true);
}

simulated function Timer()
{
    local rotator segmentRotation;
    // local sound tubesound;
    local vector minitubeoffsetvector;

    segmentRotation=Rotation;
    segmentRotation.Roll=Rand(16384);

    minitubeoffsetvector = vect(0, 0, 0);
    minitubeoffsetvector.z = 0-minitubeoffset;

    // tubesound = sound'CicadaSnds.Missile.MissileLoad';
    // playsound(tubesound,,,,,tubesoundpitch);
    // tubepitchbend(tubesoundpitchbend);

    spawn(class'MiniTubeSegment',,,Location+miniTubeOffsetVector-(Normal(Velocity)*256),segmentRotation);

}

function tubepitchbend(float bendamount)
{
	tubesoundpitch += bendamount;
}


simulated singular function HitWall(vector HitNormal, actor Wall){

    Destroy();
}


simulated function Explode(vector HitLocation,vector HitNormal)
{
    Destroy();
}

defaultproperties
{
     minitubeoffset=80.000000
     tubesoundpitch=2.000000
     tubesoundpitchbend=-0.040000
     Speed=512.000000
     MaxSpeed=512.000000
     MomentumTransfer=50000.000000
     MaxEffectDistance=7000.000000
     DrawType=DT_None
     StaticMesh=StaticMesh'WeaponStaticMesh.RocketProj'
     CullDistance=4000.000000
     bNetTemporary=False
     AmbientSound=Sound'IndoorAmbience.electricity1'
     LifeSpan=100.000000
     FluidSurfaceShootStrengthMod=8.000000
     ForceType=FT_Constant
     ForceRadius=40.000000
     ForceScale=5.000000
}
