//=============================================================================
// ShockProjectile.
//=============================================================================
class TubeMaker extends Projectile;

var int tubecolor;
// the pitch of the tube sound (between 1 and 2)
var float tubesoundpitch;
// how much the pitch of the tube sound changes per timer
var float tubesoundpitchbend;

simulated event PreBeginPlay()
{
    Super.PreBeginPlay();

    Velocity = Speed * Vector(Rotation); // starts off slower so combo can be done closer

}

simulated function PostBeginPlay()
{
    Super.PostBeginPlay();
    if(Level.NetMode!=NM_Client){
      tubecolor=rand(7);
      SetTimer(0.5,true);
    }
}

simulated function Timer()
{
    local rotator segmentRotation;
    local sound tubesound;
    segmentRotation=Rotation;
    segmentRotation.Roll=Rand(16384);

    tubesound = sound'CicadaSnds.Missile.MissileLoad';
    playsound(tubesound,,,,,tubesoundpitch);
    tubepitchbend(tubesoundpitchbend);

    switch(tubecolor){
      case 0:
        Spawn(class'TubeSegment1a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 1:
        Spawn(class'TubeSegment2a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 2:
        Spawn(class'TubeSegment3a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 3:
        Spawn(class'TubeSegment4a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 4:
        Spawn(class'TubeSegment5a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 5:
        Spawn(class'TubeSegment6a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;
      case 6:
        Spawn(class'TubeSegment7a',,,Location-(Normal(Velocity)*256),segmentRotation);
        break;

    }

}

function tubepitchbend(float bendamount)
{
	tubesoundpitch += bendamount;
}


simulated singular function HitWall(vector HitNormal, actor Wall){

    Destroy();
}


simulated function Explode(vector HitLocation,vector HitNormal)
{
    Destroy();
}

defaultproperties
{
     tubesoundpitch=2.000000
     tubesoundpitchbend=-0.040000
     Speed=512.000000
     MaxSpeed=512.000000
     MomentumTransfer=50000.000000
     MaxEffectDistance=7000.000000
     DrawType=DT_None
     StaticMesh=StaticMesh'WeaponStaticMesh.RocketProj'
     CullDistance=4000.000000
     bNetTemporary=False
     AmbientSound=Sound'IndoorAmbience.electricity1'
     LifeSpan=10.000000
     FluidSurfaceShootStrengthMod=8.000000
     ForceType=FT_Constant
     ForceRadius=40.000000
     ForceScale=5.000000
}
