class LongPawnPreserver extends Actor;

var name animname;
var float animframe;

simulated function PostBeginPlay(){

  local xpawn xvictim;

  Owner.LifeSpan=60;
  Owner.SetCollision(false, false, false);
  Owner.bCollideWorld=true;
  Owner.bBlockActors=false;
  Owner.bBlockPlayers=false;
  Owner.bBlockZeroExtentTraces=false;

  if(xPawn(Owner) != None){
    xVictim=xPawn(Owner);
    xVictim.GibGroupClass=Class'LongGibGroup';
    xVictim.RagdollLifeSpan=110;
  }


}

simulated function Tick(float DeltaTime)
{
  // if the preserver loses the reference to the owner, or the owner is blown into pieces,
  // destroy this preserver (and the owner along with it, in destroyed()). This is necessary
  // because blowing the owner into pieces doesn't actually remove their body, and the
  // preserver would leave an invisible body hanging around otherwise which blocks
  // projectiles.

  if (Owner == None)
  {
    Destroy();
    return;
  }

  if (xpawn(owner) != none && xpawn(Owner).bGibbed)
  {
    Destroy();
    return;
  }

  Owner.LifeSpan=60; //No, you can't set it to zero. Something else keeps setting it non-zero again.
  Owner.LastRenderTime=Level.TimeSeconds; //Hack.

  // continuously freezes the animation every tick, to make sure that no other animations can
  // override (eg. death anim)

  if(xPawn(Owner)!=none)
    xPawn(Owner).RagdollLifeSpan=60;
  Owner.SetTimer(0.0, false); //Worsehack
}

function Destroyed(){  //Because statues are collisions, make sure that they disappear from everywhere at once.
  if(xPawn(Owner)!=none)
    xPawn(Owner).SpawnGibs(rot(0,0,0), 1.0);
  if (Owner != None)
    Owner.Destroy();
  Super.Destroyed();
}

defaultproperties
{
     DrawType=DT_None
     RemoteRole=ROLE_SimulatedProxy
}
