class PawnPreserver extends Actor;

var name animname;
var float animframe;

simulated function Tick(float DeltaTime)
{
  // if the preserver loses the reference to the owner, or the owner is blown into pieces,
  // destroy this preserver (and the owner along with it, in destroyed()). This is necessary
  // because blowing the owner into pieces doesn't actually remove their body, and the
  // preserver would leave an invisible body hanging around otherwise which blocks
  // projectiles.

  if (Owner == None)
  {
    Destroy();
    return;
  }

  if (xpawn(owner) != none && xpawn(Owner).bGibbed)
  {
    Destroy();
    return;
  }

  Owner.LifeSpan=60;
  Owner.LastRenderTime=Level.TimeSeconds; //Hack.

  // continuously freezes the animation every tick, to make sure that no other animations can
  // override (eg. death anim)
  statuefreezeanim();

  if(xPawn(Owner)!=none)
    xPawn(Owner).RagdollLifeSpan=60;
  Owner.SetTimer(0.0, false); //Worsehack
}

function Destroyed(){  //Because statues are collisions, make sure that they disappear from everywhere at once.
  if(xPawn(Owner)!=none)
    xPawn(Owner).SpawnGibs(rot(0,0,0), 1.0);
  Owner.Destroy();
  Super.Destroyed();
}

function StatueFreezeAnim()
{
 local name vanimname;
 local float vframe,vrate;

 // player freezing already works, don't bother calling this on them
 if (monster(owner) == none)
  return;

 owner.getanimparams(0, vanimname,vframe,vrate);
  owner.playanim(vanimname, 0);

//   owner.playanim(animname, 0);
//   owner.setanimframe(animframe, 0, 1);
}

defaultproperties
{
     DrawType=DT_None
     Physics=PHYS_Trailer
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=40.000000
     CollisionRadius=25.000000
     CollisionHeight=44.000000
     bCollideActors=True
     bCollideWorld=True
     bBlockPlayers=True
}
