class StonerDelay extends Actor;

var Pawn Victim;

// monsters need to pass on the anim and frame they were in at the moment of death, which is below.
var name animname;
var float animframe;

simulated function postbeginplay(){
  local Pawn P;
  local xPawn xVictim;
  Victim=Pawn(Owner);

  // may not need this if we can pass the animframes to the pawnpreserver
  if (monster(victim) != none)
  {
   lifespan = 0.1;
   // a shorter delay should be permissible in single player, since without replication the Died() function should
   // already have returned by now
   if (level.netmode == nm_standalone)
    lifespan = 0.01;
  }


  if(Level.NetMode == NM_Client){  //Horrible, horrible hack.
    foreach VisibleCollidingActors( class 'Pawn', P, 256, Location )
      if(VSize(P.Location-Location)<vSize(Victim.Location-Location))
        Victim=P;
  
  }
  if(Victim==None)
    Destroy();

//  PlaySound(Sound'GeneralAmbience.beep10',,30,,65536,,false);
  victim.Skins[0]=Texture'Detail.metalf3';
  victim.Skins[1]=Texture'Detail.metalf3';

  if(xPawn(Victim) != None){
    xVictim=xPawn(Victim);
    xVictim.GibGroupClass=Class'StoneGibGroup';
    xVictim.RagdollLifeSpan=110;
  }

}

simulated function Destroyed(){
  local vector oldVel;
  local pawnpreserver pp;
  oldVel=victim.Velocity;
  victim.KFreezeRagdoll();
  victim.Velocity=oldVel;

  victim.LifeSpan=120;
  victim.SetCollision(true, true, true);
  victim.bCollideWorld=true;
  victim.bBlockActors=true; //It's a rock.
  victim.bBlockPlayers=true;
  victim.bBlockZeroExtentTraces=true;

  victim.bUseCylinderCollision=false;
  if (victim != none)
  {
   pp = Spawn(class'PawnPreserver',Victim,,Victim.Location);
   pp.animname = animname;
   pp.animframe = animframe;
  }
  super.Destroyed();
}

defaultproperties
{
     DrawType=DT_None
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=0.200000
}
