#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "md5.h"
//#define MS_Compiler //To compile under Windows using the cl compiler from Visual Studio 2010.
                   //Also, you have to change the extension to .cpp. Why, I don't know, but it won't take this in C.
//#define DEBUG //Adds lots  of printfs detailing every block.
#ifdef MS_Compiler
  #include <io.h>
  #define fseeko64 _fseeki64
  #define fopen64 fopen
#else
FILE* fopen64(const char *filename, const char *type); //The libraries are there, but the function definitions arn't. Easily fixed.
int fseeko64(FILE *stream, long long offset, int whence);
#endif
unsigned int blocksize;

int main(int argc, char *argv[]){
  if(argc<=1){
    printf("Usage: BLDDexpand <infile.bldd> <outfile> [-h]\n       Use - for infile to rest from stdin.\n       -h will run an MD5 hash on the data as it is written.\n");
    return(1);
  }
  printf("BLDDexpand starting.\n");
  char *outfilename;
  FILE *infile;
  if((argv[1][0]=='-')&&(argv[1][1]==0))
    infile=stdin;
  else
    infile=fopen64(argv[1], "rb");
  if(!infile){
    printf("Unable to open input file.\n");
    return(1);
  }

  if(argc>=3){
    if(strcmp(argv[2], "/dev/null")==0){
      printf("As BLDD extraction requires access to already written data, only a real file will do. No /dev/null.\n");
      return(1);
    }
    outfilename=argv[2];
  }else{
    outfilename=malloc(strlen(argv[1])+4);
    strcpy(outfilename, argv[1]);
    if((strcmp(outfilename+strlen(outfilename)-5, ".bldd")==0)||(strcmp(outfilename+strlen(outfilename)-5, ".BLDD")==0))
      outfilename[strlen(outfilename)-5]=0;
    else
      strcpy(outfilename+strlen(outfilename),".out");
  }
  md5_state_t md5state;
  unsigned char md5ing=0;
  if(argc==4)
    if(strcmp(argv[3], "-h")==0){
      printf("Initialising MD5 hash.\n");
      md5ing=1;
      md5_init(&md5state);
    }
  printf("Opening output file %s\n", outfilename);
  FILE *outfile=fopen64(outfilename,"wb+");
  if(!outfile){
    printf("Could not open file.\n");
    return(1);
  }

  unsigned char magiccheck[16];
  fread(magiccheck, 16, 1, infile);
  if(memcmp(magiccheck, "VDDCompactedFile", 16)){
    fprintf(stderr, "Error: Magic string invalid, not a BLDD file.\n");
    return(1);
  }
  unsigned char minversion=getc(infile);
  if(minversion>2){
    printf("This file is a BLDD format version %u, but this decoder supports only up to versions <=2\n", minversion);
    return(1);
  }

  blocksize=512;
  while(1){
    unsigned int headerlen;
    fread(&headerlen, 4, 1, infile);
    if(headerlen==0)
      break;
    unsigned char headbytes[4];
    fread(&headbytes, 4, 1, infile);
    if(memcmp(headbytes, "BKSZ", 4)==0){
      fread(&blocksize, 4, 1, infile);
      printf("Blocksize specified by file as %u.\n", blocksize);
    }
    else
      for(int n=4;n<headerlen;n++)
        getc(infile);
  }
  unsigned char *block=(unsigned char *)malloc(blocksize);

  printf("Extracting.\n");
  unsigned long long blocknum=0;
  unsigned long long sourceblockll=0; //For use in case 5.
  unsigned long long lastflush=0; //Windows has 'issues' sometimes with disk caching. This is for a hack to make sure they don't happen.
  while(1){
    unsigned char blockbyte=getc(infile);
    unsigned char blocktype;
    if(feof(infile)){
      printf("End of input at block %llu\n", blocknum);
      fclose(outfile);
       printf("Done.\n");
       if(md5ing){
         unsigned char dest[16];
         md5_finish(&md5state, dest);
         for(int n=0;n<16;n++)
           printf("%02X", dest[n]);
         printf("\n");
       }
      return(0);
    }

    if(blockbyte!=0xE7){
      fread(block+1, blocksize-1, 1, infile);
      //fputc(blockbyte, outfile);
      block[0]=blockbyte;
      fwrite(block, blocksize, 1, outfile);
      if(md5ing)
         md5_append(&md5state, (md5_byte_t *)block, blocksize);
      blocknum++;
    }
    else{
      blocktype=getc(infile);
      switch(blocktype){
        case 1:;
          fread(&sourceblockll, 8, 1, infile);
          #ifdef DEBUG
          printf("Block %u sourcing from %llu (0x01)\n", blocknum, sourceblockll);
          #endif
          if(sourceblockll>lastflush){ //Needed for windows, harmless on linux.
            fflush(outfile);
            lastflush=blocknum-1;
          }
          fseeko64(outfile, sourceblockll*(unsigned long long)blocksize, SEEK_SET);
          fread(block, blocksize, 1, outfile);
          fseeko64(outfile, 0, SEEK_END);
          fwrite(block, blocksize, 1, outfile);
          if(md5ing)
             md5_append(&md5state, block, blocksize);
          blocknum++;
          break;
        case 2:;
          unsigned int sourceblock;
          fread(&sourceblock, 4, 1, infile);
          #ifdef DEBUG
          printf("Block %u sourcing from ", blocknum); //Microsoft compiler absolutly refuses to print two numbers in one printf call. Weird.
          printf("%u (0x02)\n", sourceblock);
          #endif
          if(sourceblockll>lastflush){ //Needed for windows, harmless on linux.
            fflush(outfile);
            lastflush=blocknum-1;
          }
          sourceblockll=sourceblock;
          fseeko64(outfile, sourceblockll*(unsigned long long)blocksize, SEEK_SET);
          fread(block, blocksize, 1, outfile);
          if(fseeko64(outfile, 0, SEEK_END)){
            fprintf(stderr, "Seek to end failed! Fatal.\n");
            return(-1);
          }
          fwrite(block, blocksize, 1, outfile);
          if(md5ing)
             md5_append(&md5state, block, blocksize);
          blocknum++;
          break;
        case 3:
          memset(block, 0, blocksize);
          fwrite(block, blocksize, 1, outfile);
          if(md5ing)
             md5_append(&md5state, block, blocksize);
          #ifdef DEBUG
            printf("Block %u is null\n", blocknum);
          #endif
          blocknum++;
          break;
        case 4:;		
          unsigned int numnewblocks;
          fread(&numnewblocks, 4, 1, infile);
          #ifdef DEBUG
          printf("Getting %u new unencoded blocks.\n", numnewblocks);
          #endif
          for(;numnewblocks--;){
            fread(block, blocksize, 1, infile);
            if(fwrite(block, blocksize, 1, outfile)!=1){
              printf("Write failed at block %llu. Unrecoverable error. Most likely cause is out of disk space.\n", blocknum);
              return(1);
            }
            if(md5ing)
               md5_append(&md5state, block, blocksize);
            blocknum++;
          }
          break;
        case 5:
          sourceblockll++;
          #ifdef DEBUG
          printf("Block %u sourcing from %u (n+1).\n", blocknum, sourceblockll);
          #endif
          if(sourceblockll>lastflush){ //Needed for windows, harmless on linux.
            fflush(outfile);
            lastflush=blocknum-1;
          }
          fseeko64(outfile, sourceblockll*(unsigned long long)blocksize, SEEK_SET);
          fread(block, blocksize, 1, outfile);
          fseeko64(outfile, 0, SEEK_END);
          fwrite(block, blocksize, 1, outfile);
          if(md5ing)
             md5_append(&md5state, block, blocksize);
          blocknum++;
          break;
        case 0xE7: //It really is a 0xE7.
          fread(block+1, blocksize-1, 1, infile);
          //fputc(0xE7, outfile);
          block[0]=0xE7;
          if(fwrite(block, blocksize, 1, outfile)!=1){
            printf("Write failed at block %llu. Unrecoverable error. Most likely cause is out of disk space.\n", blocknum);
            return(1);
          }
          if(md5ing)
             md5_append(&md5state, block, blocksize);
          blocknum++;
          break;
        case 0x06:
          fread(&numnewblocks, 4, 1, infile);
          printf("End of file marker found - tails not handled in this version, but next would would be %u bytes long.\n", numnewblocks);

      }
    }
  }

}
