#include <stdio.h>

//Demonstration of the move-to-front transform.
unsigned char move2front(unsigned char c, unsigned char *array);

int main(int argc, char *argv[]){
  unsigned char m2f_array[256];
  int n;
  for(n=0;n<256;n++)
    m2f_array[n]=n;
  while(1){
    unsigned char i=getchar();
    if(feof(stdin))
      break;
    printf("%c", move2front(i, m2f_array));
  }
}


unsigned char move2front(unsigned char c, unsigned char *array){
  //To use:
  //1. Initialise the array. It's 256 bytes, containing the values 0 to 255.
  //   You can use any order really, so long as the decoder uses the same.
  //2. Call for each byte in order (You can do this streaming or for a block.)
  //   The array will be modified each call.
  int n=0;int m=0;
  while(array[n]!=c)
    n++;
  unsigned char t=array[n];
  for(m=n;m>0;m--)
    array[m]=array[m-1];
  array[0]=t;
  return(n);
}
