#include <stdio.h>


void out_chars(char t, unsigned char len, unsigned char minlen);
void rle_enc(unsigned char minlen);
void rle_dec(unsigned char minlen);

int main(int argc, char *argv[]){
  if(argc<2){
    printf("This is a simple run-length encoder intended for use in demonstrating the algorithm or testing various forms of compression upon data to determine an optimal chain.\n");
    printf("usage: RLE <len> [anything]\n  Len is the minimum length string to encode (Optimal value usually around 2-5) and must be the same when encoding and decoding.\n  The third parameter selects decoding mode - doesn't actually matter what you put, just the presence is enough.\n");
    return(1);
  }

  unsigned char minlen=atoi(argv[1]);
  if(argc==2)
    rle_enc(minlen);
  else
    rle_dec(minlen);
}

void rle_enc(unsigned char minlen){
 char cur=getchar();
 unsigned char count=1;
 do{
   char n; 
   n=getchar();
   if((n==cur) && (count<255))
     count++;
   else{
     out_chars(cur, count, minlen);
     count=1;
     cur=n;
   }
 }while(!feof(stdin));
}

void out_chars(char t, unsigned char len, unsigned char minlen){
//  putchar('(');putchar(t);putchar(len);putchar(minlen);putchar(')');
  if(len<minlen){
    for(;len--;)
      putchar(t);
    return;
  }
  unsigned char c=minlen;
  for(;c--;)
    putchar(t);
  putchar(len-minlen);
  
}

void rle_dec(unsigned char minlen){
  unsigned char count=0;
  char l=0;
  char c=getchar();
  do{
   putchar(c);
   if(c==l)
     count++;
   else{
     count=0;
     l=c;
   }
   if(count==(minlen-1)){
     count=getchar();
//     printf("(%u-%u)", c, count);
     for(;count--;)
       putchar(c);
     count=0;
   }
   c=getchar();
  }while(!feof(stdin));

}
