#define ALSA_PCM_NEW_HW_PARAMS_API

#include <alsa/asoundlib.h>
//#include "HDLC.cpp"

#include <stdint.h>
    static float convolver_kernel[44]={
     0.11309808,
     0.11058585,
     0.10326328,
     0.09174974,
     0.07700381,
     0.06022216,
     0.04271553,
     0.02577672,
     0.01055575,
    -0.00204361,
    -0.01143499,
    -0.01738185,
    -0.01998954,
    -0.01966063,
    -0.017021297806472404,
    -0.01282973,
    -0.007878976178207943,
    -0.00290628,
     0.00148057,
     0.00485281,
     0.00698247,
     0.00783690,
     0.00755005,
     0.00637696,
     0.00463981,
     0.00267375,
     0.00077983,
    -0.00080950,
    -0.00194937,
    -0.00258578,
    -0.00274522,
    -0.00251443,
    -0.00201514,
    -0.00137848,
    -0.000723318114528775,
    -0.000141238619070746,
    0.000310658175055477,
    0.000609412323056045,
    0.000760010758076556,
    0.000785774707389098,
    0.000718003797765708,
    0.000587229606102550,
    0.000417681352135680,
    0.000225579855100789};
class convolver{
  //This is a very specific purpose convolvolution. All vital paramaters are hard-coded.
  //It's a low-pass filter, specifically for use in the Bird Modem.
  //It's also not the most CPU-efficient algorithm, but close enough.
  //The kernal is stored as 44 values, but is actually 87 once mirrored. This means the buffer must be six symbols in length.
  public:
    void clear(){
      for(int n=0;n<(18*6);n++)
        convolve_buffer[n]=0;
    }
    convolver(){
      clear();
    }
    void filter(int16_t *new_samples, int16_t *out_samples){
      for(int n=0;n<(18*5);n++)
        convolve_buffer[n]=convolve_buffer[n+18];
      for(int n=0;n<18;n++)
        convolve_buffer[n+(18*5)]=new_samples[n];
      //Now for the convolution! This is actually a symmetric convolver_kernel, but only half of it is stored in the array.
      for(int n=0;n<18;n++)
        scratch_buffer[n]=convolve_buffer[43+n]*convolver_kernel[0];
      for(int n=0;n<18;n++)
        for(int m=1;m<44;m++){
          scratch_buffer[n]+=convolve_buffer[43+n+m]*convolver_kernel[m];
          scratch_buffer[n]+=convolve_buffer[43+n-m]*convolver_kernel[m];
        }
      for(uint8_t n=0;n<18;n++)
        out_samples[n]=scratch_buffer[n];
    }
  private:
    int16_t convolve_buffer[18*6];
    int32_t scratch_buffer[18];

};


class birdmodem_RAW{
  public:
    bool stdio_mode; //For use in testing, mostly.

    birdmodem_RAW(){
      stdio_mode=false;
      convolve=new convolver;
      init_sound();
      for(int n=0;n<9;n++){
        symbol_one[n]=13000;
        symbol_one[n+9]=-13000;
        symbol_two[n]=-13000;
        symbol_two[n+9]=13000;
      }
    }

    ~birdmodem_RAW(){
      for(int n=0;n<18;n++)
        symbol_one[n]=0;
      for(int n=0;n<64;n++){
        convolve->filter(symbol_one, output_buffer);
        playsamples(output_buffer);
      }
      if(!stdio_mode){
        do{sleep(1);}while(snd_pcm_avail_update(handle)>0);
        snd_pcm_drain(handle); //Drains the buffer, but even then some sound managers will buffer too.
                              //And truncate upon process termination. Thus the above. It's a precaution against that happening.
      }
      delete(convolve);convolve=NULL;
    }
    int send_bit(bool bit){
      if(bit)
        convolve->filter(symbol_one, output_buffer);
      else
        convolve->filter(symbol_two, output_buffer);
      if(stdio_mode){
        fwrite(output_buffer, 2, 18, stdout);
        return(0);
      }
      return(playsamples(output_buffer));
    }
    bool is_paused(){
      snd_pcm_state_t s=snd_pcm_state(handle);
//printf("!:%d:%ld\n",s,snd_pcm_avail_update(handle));
      return(s==SND_PCM_STATE_PAUSED ||
             s==SND_PCM_STATE_XRUN ||
             snd_pcm_avail_update(handle)<=0);
    }
    void recover(){
      snd_pcm_recover(handle,0-EPIPE,true);
      convolve->clear();
      for(int n=0;n<20;n++){
        snd_pcm_writei(handle,symbol_quiet, 18);
      }
    }
  private:
    snd_pcm_t *handle;
    convolver *convolve;
    int16_t symbol_one[18];
    int16_t symbol_two[18];
    int16_t symbol_quiet[18];
    int16_t output_buffer[18];
    uint16_t *silenttenth;
    void init_sound(){
      int rc = snd_pcm_open(&handle, "default", SND_PCM_STREAM_PLAYBACK, 0);
      if (rc < 0) {
        fprintf(stderr, "unable to open ALSA pcm device: %s\n", snd_strerror(rc));
        return;
      }
      int err;
      unsigned int samplerate=44100;
      snd_pcm_hw_params_t *params;
      snd_pcm_hw_params_alloca(&params);
      snd_pcm_hw_params_any(handle, params);
      snd_pcm_hw_params_set_access(handle, params,SND_PCM_ACCESS_RW_INTERLEAVED);
      err=snd_pcm_hw_params_set_format(handle, params,SND_PCM_FORMAT_S16);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_params_set_format: %s.\n", snd_strerror(err));
      err=snd_pcm_hw_params_set_channels(handle, params, 1);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_set_channels: %s.\n", snd_strerror(err));
      int dir;
      err=snd_pcm_hw_params_set_rate_near(handle, params, &samplerate, &dir);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_params_set_rate_near: %s.\n", snd_strerror(err));
      if(samplerate!=44100){fprintf(stdout, "Error setting samplerate - should be 44100, got %d\n", samplerate);}
      rc = snd_pcm_hw_params(handle, params);
      if (rc < 0)
        fprintf(stderr,"unable to set hw parameters: %s\n",snd_strerror(rc));
      silenttenth=(uint16_t*)malloc(4410*sizeof(uint16_t));
      snd_pcm_writei(handle,silenttenth, 4410);

    }
    uint8_t playsamples(int16_t *buffer){

      snd_pcm_sframes_t ret;
      ret=snd_pcm_writei(handle,buffer, 18);
      if(ret==(0-EPIPE)){
        //Underrun occured. Either we ran out of CPU resources for a moment, or data ran dry.
        //fprintf(stderr, "Underrun in playsamples()\n");
        snd_pcm_recover(handle,ret,true);
        snd_pcm_writei(handle,silenttenth, 4410);
        convolve->clear();
        return(1); //And tell the caller to scratch the frame and send over.
      }
      return(0);
    }

};

class hdlc_receiver_modem: public hdlc_receiver{ //It's just like the hdlc_receiver, except it can reject duplicate detections.
  public:
    uint8_t *receive_inhibit;
    hdlc_receiver_modem(uint32_t max_size):hdlc_receiver(max_size){}
  private:
    void potential_frame(){
      if(!receive_inhibit[0]){
        gotFrameCallback(this);
        if(checksum!=HDLC_CSUM_NONE)
          receive_inhibit[0]=16;
      }
    }
};

class birdmodem_RX{
  public:
    bool stdio_mode; //For use in testing, mostly.

    uint8_t receive_inhibit;
    bool finished; //Set true to cleanly exit.
    birdmodem_RX(uint32_t max_size){
      finished=false;
      stdio_mode=false;
      receive_inhibit=0;
      convolve=new convolver;
      init_sound();
      for(int n=0;n<18;n++){
//        hdlc_bitstream_searcher[n].set_callback(&process_decoded_frame);
        hdlc_bitstream_searcher[n]=new hdlc_receiver_modem(max_size);
        hdlc_bitstream_searcher[n]->receive_inhibit=&receive_inhibit;
        hdlc_bitstream_searcher[n]->min_length=5;
        hdlc_bitstream_searcher[n]->max_length=max_size;
      }
    }
    void set_post_receive_function(void (* post_receive_function)(hdlc_receiver*)){
      for(int n=0;n<18;n++)
        hdlc_bitstream_searcher[n]->post_receive_function=post_receive_function;
    }
    void set_checksum(int checksum){
      for(int n=0;n<18;n++)
        hdlc_bitstream_searcher[n]->checksum=checksum;
    }

    void receive_thread(){
      do{
        int16_t receive_buffer[18*2];
        int16_t read_buffer[18];
        int err;
        if(receive_inhibit>0)
          receive_inhibit--;
        for(int n=0;n<(18);n++)
          receive_buffer[n]=receive_buffer[n+18]; //At these bitrates, processor time is not a big concern.
        if(stdio_mode){
          if(fread(read_buffer, 2, 18, stdin)!=18)
            finished=true;
 
        }
        else if ((err = snd_pcm_readi (handle, read_buffer, 18)) != 18)
          fprintf (stderr, "read from audio interface failed (%d/%s)\n", err, snd_strerror (err));
        convolve->filter(read_buffer,&receive_buffer[18]);
        for(int n=0;n<18;n++){
//printf("%d|",receive_buffer[n]);
          hdlc_bitstream_searcher[n]->new_bit(receive_buffer[n]>receive_buffer[n+1]);
        }
//printf("\n");
      }while(!finished);
    }
    void set_callback(void (* newGotFrameCallback)(hdlc_receiver*)){
      for(int n=0;n<18;n++)
        hdlc_bitstream_searcher[n]->set_callback(newGotFrameCallback);
    }
  private:
    snd_pcm_t *handle;
    convolver *convolve;
    hdlc_receiver_modem *hdlc_bitstream_searcher[18];
    void init_sound(){
      int rc = snd_pcm_open(&handle, "default", SND_PCM_STREAM_CAPTURE, 0);
      if (rc < 0) {
        fprintf(stderr, "unable to open ALSA pcm device: %s\n", snd_strerror(rc));
        return;
      }
      int err;
      unsigned int samplerate=44100;
      snd_pcm_hw_params_t *params;
      snd_pcm_hw_params_alloca(&params);
      snd_pcm_hw_params_any(handle, params);
      snd_pcm_hw_params_set_access(handle, params,SND_PCM_ACCESS_RW_INTERLEAVED);
      err=snd_pcm_hw_params_set_format(handle, params,SND_PCM_FORMAT_S16);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_params_set_format: %s.\n", snd_strerror(err));
      err=snd_pcm_hw_params_set_channels(handle, params, 1);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_set_channels: %s.\n", snd_strerror(err));
      int dir;
      err=snd_pcm_hw_params_set_rate_near(handle, params, &samplerate, &dir);
      if(err) fprintf(stderr, "Fatal error calling snd_pcm_hw_params_set_rate_near: %s.\n", snd_strerror(err));
      if(samplerate!=44100){fprintf(stdout, "Error setting samplerate - should be 44100, got %d\n", samplerate);}
      rc = snd_pcm_hw_params(handle, params);
      if (rc < 0)
        fprintf(stderr,"unable to set hw parameters: %s\n",snd_strerror(rc));
    }


};

class birdmodem_TX: public hdlc_composer{
  public:
    birdmodem_TX(uint32_t max_size){
     max_frame_size=max_size; 
     frame=(uint8_t*)malloc(max_frame_size);
      stuffing_counter=1;
      checksum=HDLC_CSUM_CRC32B;
      preamble_len=100;
      no_diff_encode=false;pre_send_function=NULL;frame_length=0;diffbit=0;
    }

    birdmodem_RAW modem_sender;
    void send_frame(){
      if(modem_sender.is_paused()){
        modem_sender.recover();
        send_sync_sequence(preamble_len);
      }

      hdlc_composer::send_frame();
    }
  private:
  bool diffbit; //Remember, differential encoding. A 0 is a change, a 1 is a repeat.
  //uint8_t stuffing_counter;

  int sendbit(bool bit){

    //Stuffing first - we need to make sure that five consecutive ones are followed by a zero.
    //Why? Two reasons: One, to make sure the 01111110 sync flag is distinctive. Look up HDLC for details.
    //Two, because occasional phase changes actually help the PLL at the receiving end aquire lock.
      if(stuffing_counter){ //Setting stuffing_counter to 0 is used to disable stuffing while sending the sync symbol.
        if(bit)
          stuffing_counter++;
        if(stuffing_counter==6){
          stuffing_counter=1;
          if(sendbit(1)) return(1);bit=0;
        }
        if(!bit)
          stuffing_counter=1;
      }
    if(no_diff_encode)
      return(modem_sender.send_bit(bit));
    if(!bit)
      diffbit=!diffbit;
//printf(" %u:%u ",bit,diffbit);

    return(modem_sender.send_bit(diffbit));
  }
};

