#undef __ANSIC__
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
//#include <unistd.h>
//#include <time.h>

//#include <./crc32.h>
#include "md5.h"

typedef struct{
	unsigned long crc32;
	unsigned char md5[16];
	unsigned int found; //Used as a boolean really. But try to keep it as a multible of four bytes, to ensure alignment.
} hashpairstruct;

typedef struct{
	unsigned char ID[16];
	unsigned char md5[16];
	unsigned long long filesize;
	unsigned int foundslices;
	char *filename;
	unsigned int numberofhashes;
	hashpairstruct *hashpairs;
} filedetail;

typedef struct{
	unsigned long long slicesize;
	unsigned int numberoffiles;
	filedetail *files;
} par2contents;

/* typedef a 32 bit type */
/*typedef unsigned long int UINT4;


//Data structure for MD5 (Message Digest) computation
typedef struct {
  UINT4 i[2];                   // number of _bits_ handled mod 2^64
  UINT4 buf[4];                                    // scratch buffer
  unsigned char in[64];                              // input buffer
  unsigned char digest[16];     // actual digest after MD5Final call
} MD5_CTX; */

void invalidcommandline();
int parsepar2(FILE *par2file, char verbose);
int getfilebyid(unsigned char *ID);
void checkfile(FILE *readfile, unsigned int incriment);
int handlechunk(unsigned char *chunk);
FILE *fopen64(const char *filename, const char *type);
//int fseeko64(FILE *stream, unsigned long long offset, int whence);

unsigned int crc32 (unsigned char *buffer, unsigned int len); //From crc32.h

par2contents par2_details;

int main(int argc, char *argv[]){
	if(argc<=2){
		invalidcommandline();
		return(1);
	}
	//First task: Locate and load the par2 file.
	for(int n=1; n<argc; n++){
		if(argv[n][0]=='-'){
			if(argv[n][1]=='l'){
				//argv[n+1] contains the par2 file.
				printf("Opening par2 file %s\n", argv[n+1]);
				FILE *par2file=fopen(argv[n+1], "rb");
				if(par2file==NULL){
					printf("  FAILED!\n");
					return(1);
				}
				if(parsepar2(par2file, 0)!=0){
					printf("Error reading par2 file\n");
					fclose(par2file);
					return(1);
				}
				fclose(par2file); //Done reading. par2_details now contains all the needed metadata.
			}
			n++;
		}
	}
	mkdir("parscavenge_output", S_IRWXU);
	//Now to claim some data.
	for(int n=1; n<(argc-1); n++){
		//printf("delta-poke %u.\n", n);
		if(argv[n][0]=='-'){
			if((argv[n][1]=='i')||(argv[n][1]=='d')){
				//argv[n+1] contains the input file.
				printf("Opening input file %s\n", argv[n+1]);
				FILE *currentfile=fopen64(argv[n+1], "rb");
				if(currentfile==NULL){
					printf("  Unable to open file.\n");
					return(1);
				}
				if(argv[n][1]=='d')
					checkfile(currentfile, 512);
				if(argv[n][1]=='i')
					checkfile(currentfile, par2_details.slicesize);
				fclose(currentfile);
				//printf("Alpha-poke.\n");

			}
			//printf("Beta-poke.\n");
			n++;
		}
		else{
				printf("Opening input file %s\n", argv[n+1]);
				FILE *currentfile=fopen64(argv[n], "rb");
				if(currentfile==NULL){
					printf("  Unable to open file.\n");
					return(1);
				}
				checkfile(currentfile, 512);
				fclose(currentfile);

		}
		//printf("Gamma-poke %u.\n", n);
	}
	//printf("Epsilon-poke.\n");
	printf("Scavenging complete. Padding any incomplete files to the correct length:  \n");
	int totalslices=0;
	unsigned char *nullbuffer=malloc(par2_details.slicesize);
	for(int n=0; n<par2_details.numberoffiles; n++){
		if(par2_details.files[n].foundslices){
			totalslices+=par2_details.files[n].foundslices;
			if(par2_details.files[n].hashpairs[par2_details.files[n].numberofhashes-1].found==0){
				printf("!");
				char *tempstring=malloc(255);
				memset(tempstring, 0, 255);
				memcpy(tempstring, "parscavenge_output/", 19);
				strcat(tempstring, par2_details.files[n].filename);
				FILE* putchunkhere=fopen64(tempstring, "r+b"); //Open the file to add the cunk to.
				//if(putchunkhere==NULL) //Perhaps the file doesn't exist.
					//putchunkhere=fopen64(tempstring, "wb"); //If so, create it.
				free(tempstring);
				fseeko64(putchunkhere, par2_details.slicesize*(par2_details.files[n].numberofhashes-1), SEEK_SET);
					fwrite(nullbuffer, par2_details.files[n].filesize-(par2_details.slicesize*(par2_details.files[n].numberofhashes-1)), 1, putchunkhere);
				fclose(putchunkhere);
			}
		}
	}
	free(nullbuffer);
	printf("\n Done! Completed successfully, saved %u slices.\n", totalslices);

	return(0);
}



void invalidcommandline(){
	printf("Invalid command line\n");
	printf("  -l <par2file>     specify par2 file (Manditory, exactly once)\n");
	printf("  <inputfile>       A file to search for data.");
	printf("  -i <datafile>     A file to search for data using 'correct offset only' high speed approach.\n");
	printf("    parscavanger will extract valid slices from any horrid tangle of input files using the hashes from a par2 file, and rearrange them into a clean, tidy output folder in such a way that every part of the file is either good, or nulled out. This makes the use of further data-recovery or repair utilities much simpler.\n");
	//Not implimented yet: printf("  The optional flag -c will cause the dumping of raw slices, rather than complete files.\n);
}


int parsepar2(FILE *par2file, char verbose){
	//Par2 file goes in. And out comes a monster of a struct defining... everything it reads. Filenames, sizes, lists of hashes. All of size unknown at this time, of course.
	//How monster? Well, how about this function returning a pointer to a struct containing an array of pointers to structs containing arrays of pointers to pointers to fixed-length strings? Yes, that monster.
	//First, check for the magic bytes.
	unsigned char *buffer16=malloc(16); //A 16-byte buffer
	fread(buffer16, 8, 1, par2file);
	if(memcmp(buffer16, "PAR2\0PKT", 8)!=0){
		free(buffer16);
		return(1);
	}
; //On completion, this will be copied into the address of par2_struct_return.
	//First task is to locate the main packet.

		int foundmain=0;
		do{
			unsigned long long packetsize; //I so like it when file designers use enough bits.
			fread(&packetsize, 8, 1, par2file);
			fread(buffer16, 16, 1, par2file); //The packet md5. Discard this.
			fread(buffer16, 16, 1, par2file); //The set ID. Discard this.
			fread(buffer16, 16, 1, par2file); //The packet type
			if(memcmp(buffer16, "PAR 2.0\0Main\0\0\0\0", 16)==0){
				//Main packet found.
				printf("  Found par2 main packet.\n");
				foundmain=-1;
				fread(&par2_details.slicesize, 8, 1, par2file);
				printf("    Slice size          : %llu\n", par2_details.slicesize);
				fread(&par2_details.numberoffiles, 4, 1, par2file);
				printf("    Number of files     : %u\n", par2_details.numberoffiles);
				par2_details.files=malloc(sizeof(filedetail)*par2_details.numberoffiles);
				for(int n=0; n<par2_details.numberoffiles; n++){
					fread(&par2_details.files[n].ID, 16, 1, par2file);
				}
				printf("    File IDs read.\n");
			}
			else{
				//This packet is of no use for now. Skip it.
				//printf("  Skipping packet %lu\n", packetsize);
				fseek(par2file, packetsize-56, SEEK_CUR); //56 is the size of the four fields already read: size, md5, set, type.
			}
			if((!foundmain)&&feof(par2file)){
				printf("  End of par2 file reached but no main packet found.\n");
				free(buffer16);
				return(1);
			}
	}while(!foundmain);
	//First pass done... now for the good bit. Find the file details.
	fseek(par2file, 8, SEEK_SET); //Back to the start, skipping the magic bytes.
	printf("  Reading file descriptor packets:\n");
	do{
		unsigned long long packetsize; //I so like it when file designers use enough bits.
		fread(&packetsize, 8, 1, par2file);
		fread(buffer16, 16, 1, par2file); //The packet md5. Discard this.
		fread(buffer16, 16, 1, par2file); //The set ID. Discard this.
		fread(buffer16, 16, 1, par2file); //The packet type
		if(memcmp(buffer16, "PAR 2.0\0FileDesc", 16)==0){
			//Filedesc packet.
			if(verbose)
				printf("    Found file descriptor packet:\n");
			fread(buffer16, 16, 1, par2file); //The file ID.
			int filenumber=getfilebyid(buffer16);
			if(filenumber==-1){
				printf("      File found with ID not in par2 main packet.\n");
				free(buffer16);
				return(1);
			}
			if(verbose)
				printf("      File number       : %u\n", filenumber);
			fread(par2_details.files[filenumber].md5, 16, 1, par2file);
			fread(buffer16, 16, 1, par2file); //Skip md5-16k.
			fread(&par2_details.files[filenumber].filesize, 8, 1, par2file);
			if(verbose)
				printf("      File size         : %llu\n", par2_details.files[filenumber].filesize);
			int filenamelength=packetsize-112;
			par2_details.files[filenumber].filename=malloc(filenamelength+1); //nullterm
			fread(par2_details.files[filenumber].filename, filenamelength, 1, par2file);
			par2_details.files[filenumber].filename[filenamelength-1]=0; //Make sure its terminated.
			if(memcmp(par2_details.files[filenumber].filename+filenamelength-8, "PAR2", 4)==0)
				memset(par2_details.files[filenumber].filename+filenamelength-8, 0, 4); //Due to par2s strange round-to-four-bytes-but-dont-null-terminate strings.
			if(verbose)
				printf("      Filename          : %s\n", par2_details.files[filenumber].filename);
		}
		else{
			//This packet is of no use for now. Skip it.
			//printf("  Skipping packet %ul\n", packetsize);
			if(!feof(par2file))
				fseek(par2file, packetsize-56, SEEK_CUR); //56 is the size of the four fields already read: size, md5, set, type.
		}
	}while(!feof(par2file));
	//Almost. The final stage now is to get the file slice hashes.
	fseek(par2file, 8, SEEK_SET); //Here we go again.
	printf("  Reading slice hash packets:\n");
		do{
			unsigned long long packetsize; //I so like it when file designers use enough bits.
			fread(&packetsize, 8, 1, par2file);
			fread(buffer16, 16, 1, par2file); //The packet md5. Discard this.
			fread(buffer16, 16, 1, par2file); //The set ID. Discard this.
			fread(buffer16, 16, 1, par2file); //The packet type
			if(memcmp(buffer16, "PAR 2.0\0IFSC\0\0\0\0", 16)==0){
				if(verbose)
					printf("    Found slice hash packet:\n");
				fread(buffer16, 16, 1, par2file); //Get the file ID.
				int filenumber=getfilebyid(buffer16);
				if(verbose)
					printf("      Identified as file %s\n", par2_details.files[filenumber].filename);
				int numberofhashes;
				if(par2_details.files[filenumber].filesize % par2_details.slicesize == 0)
					numberofhashes=par2_details.files[filenumber].filesize/par2_details.slicesize;
				else
					numberofhashes=par2_details.files[filenumber].filesize/par2_details.slicesize+1;
				if(verbose)
					printf("      Reading %u hashes.\n", numberofhashes);
				par2_details.files[filenumber].numberofhashes=numberofhashes;
				par2_details.files[filenumber].hashpairs=malloc(sizeof(hashpairstruct)*numberofhashes);
				for(int n=0; n<numberofhashes; n++){
					fread(par2_details.files[filenumber].hashpairs[n].md5, 16, 1, par2file);
					fread(&par2_details.files[filenumber].hashpairs[n].crc32, 4, 1, par2file);
					par2_details.files[filenumber].hashpairs[n].found=0;
				}
				fseek(par2file, packetsize-((numberofhashes*20)+56+16),SEEK_CUR); //Padding
				//printf("%u  ", packetsize);
				//printf("%u\n", (numberofhashes*20)+56+16);
				//fread(buffer16, 8, 1, par2file);
			}
			else{
				//This packet is of no use for now. Skip it.
				//printf("  Skipping packet %ul\n", packetsize);
				if(!feof(par2file))
					fseek(par2file, packetsize-56, SEEK_CUR); //56 is the size of the four fields already read: size, md5, set, type.
			}
	}while(!feof(par2file));
	free(buffer16);
	return(0);
}

int getfilebyid(unsigned char *ID){
	for(int n=0; n<par2_details.numberoffiles; n++){
		if(memcmp(ID, par2_details.files[n].ID, 16)==0)
			return(n);
	}
	return(-1);
}

void checkfile(FILE *readfile, unsigned int incriment){
	unsigned char *slicebuffer=malloc(par2_details.slicesize); //Big chunk of ram.
	unsigned long long currentoffset=0;
	int retvalue;
	int lastonehit;
	do{
		memset(slicebuffer, 0, par2_details.slicesize);
		if((currentoffset&0xFFFF)==0)
			printf("Currently at offset %llu\n", currentoffset);
		fseeko64(readfile, currentoffset, SEEK_SET);
		fread(slicebuffer, par2_details.slicesize, 1, readfile);
		retvalue=handlechunk(slicebuffer);
		if(retvalue){
			currentoffset+=par2_details.slicesize;
			lastonehit=1;
			if(retvalue>0){
				//guessed value of next slice.
				printf("Last slice. %u\n", retvalue);
				fseeko64(readfile, currentoffset, SEEK_SET);
				memset(slicebuffer, 0, par2_details.slicesize);
				fread(slicebuffer, retvalue, 1, readfile);
				if(handlechunk(slicebuffer)){
					//Found the final chunk.
					currentoffset=currentoffset+(retvalue&0xFFFFFE00); //move forwards, and round down to 512.
					printf("Completed file, new offset %llu.\n", currentoffset);
					lastonehit=0;
				}
			}
		}
		else
			if(lastonehit&&(incriment<par2_details.slicesize)){
				//Last one hit, this one didn't.
				//
				printf("Lost the file... checking ahead one block.\n");
				fseeko64(readfile, currentoffset+par2_details.slicesize, SEEK_SET);
				fread(slicebuffer, par2_details.slicesize, 1, readfile);
				if(handlechunk(slicebuffer)){
					currentoffset+=par2_details.slicesize;
					printf("  Success!\n");
				}
				else{
					printf("  Failure!\n");
					lastonehit=0;
					currentoffset+=incriment;
				}
			}
			else
			{
				currentoffset+=incriment;
			}
	}while(!feof(readfile));
	free(slicebuffer);
	printf("Finished input file.\n");
}

int handlechunk(unsigned char *chunk){
	//I have a chunk of data! Determine where to put it, then put it there.
	//Returns 0 if the chunk doesn't match any specified hashes, nonzero if it does.
	// -1 means 'it matches'
	// positive anything
	unsigned int crc32_of_chunk;
	//clock_t start=clock();
	crc32_of_chunk=crc32(chunk, par2_details.slicesize);
	//clock_t end=clock();
	//printf("CRC32 took %ld\n", end-start);
	for(int n=0; n<par2_details.numberoffiles; n++){
		for(int m=0; m<par2_details.files[n].numberofhashes; m++){
			unsigned long comparingcrc=par2_details.files[n].hashpairs[m].crc32;
			//printf("Checking %u %u, %u, %u\n", n, m, comparingcrc, crc32_of_chunk);
			if(comparingcrc==crc32_of_chunk){
				//printf("CRC32 match.\n");
				//This is probably a match now. But to be sure, check the md5.
				unsigned char hashdest[16];
				md5_state_t state;
				md5_init(&state);
				md5_append(&state, chunk, par2_details.slicesize);
				md5_finish(&state, hashdest);


				if(memcmp(par2_details.files[n].hashpairs[m].md5, hashdest,16)==0){
					printf("Match! File %d, Slice %d.\n", n, m);
					if(par2_details.files[n].hashpairs[m].found==0){ //If this chunk is already known, dont bother.
						par2_details.files[n].hashpairs[m].found=1;
						par2_details.files[n].foundslices++;
						char *tempstring=malloc(255);
						memset(tempstring, 0, 255);
						memcpy(tempstring, "parscavenge_output/", 19);
						strcat(tempstring, par2_details.files[n].filename);
						FILE* putchunkhere=fopen64(tempstring, "r+b"); //Open the file to add the cunk to.
						if(putchunkhere==NULL) //Perhaps the file doesn't exist.
							putchunkhere=fopen64(tempstring, "wb"); //If so, create it.
						free(tempstring);
						fseeko64(putchunkhere, par2_details.slicesize*m, SEEK_SET);
						if(m==par2_details.files[n].numberofhashes-1)
							fwrite(chunk, par2_details.files[n].filesize-(par2_details.slicesize*m), 1, putchunkhere);
						else
							fwrite(chunk, par2_details.slicesize, 1, putchunkhere);
						fclose(putchunkhere);
					}
					if(m==(par2_details.files[n].numberofhashes-2))
						return(par2_details.files[n].filesize-(par2_details.slicesize*(m+1)));
					return(-1);
				}
			}
		}
		//if(n==0)
		//	return(0); //For testing.
	}
	return(0);
}

// Everything from here on is CRC code. I couldn't get it to work from an include file, so I appended it to the main one.

/*
 * crc32.h
 *
 * Description:  CRC32 functions
 * Developed by: Alexander Djourik <sasha@iszf.irk.ru>
 *               Pavel Zhilin <pzh@iszf.irk.ru>
 *
 * Copyright (c) 1999-2004 Alexander Djourik. All rights reserved.
 *
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Please see the file COPYING in this directory for full copyright
 * information.
 */
static const unsigned long crc32_table[256] = {
        0x00000000, 0x77073096, 0xee0e612c, 0x990951ba,
        0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3,
        0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988,
        0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91,
        0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de,
        0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
        0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec,
        0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5,
        0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172,
        0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
        0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940,
        0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
        0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116,
        0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f,
        0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
        0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d,
        0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a,
        0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
        0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818,
        0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
        0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e,
        0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457,
        0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c,
        0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
        0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2,
        0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb,
        0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0,
        0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9,
        0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086,
        0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
        0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4,
        0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad,
        0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a,
        0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683,
        0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8,
        0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
        0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe,
        0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7,
        0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc,
        0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
        0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252,
        0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
        0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60,
        0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79,
        0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
        0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f,
        0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04,
        0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
        0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a,
        0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
        0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38,
        0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21,
        0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e,
        0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
        0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c,
        0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45,
        0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2,
        0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db,
        0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0,
        0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
        0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6,
        0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf,
        0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94,
        0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d
};

/*#define UPDATE_CRC32(x, crc) crc = \
        (((crc>>8) & 0x00FFFFFF) ^ crc32_table[(crc^x) & 0xFF])

static unsigned long
crc32 (unsigned char *buffer, unsigned long len) {
        unsigned long   i;
        unsigned long   crc = 0xFFFFFFFF;

        for (i = 0; i < len; i++) UPDATE_CRC32(buffer[i], crc);

        return (crc ^ 0xFFFFFFFF);
}*/


	unsigned int update_crc32(unsigned int crc, unsigned char* buf, unsigned int len)
	{
		//MAKE THE CRC TABLE BEFORE USE!
		//if len=0, continues to end of buffer
		unsigned int c = crc;
		unsigned char* end=buf+len; //Beware of overflows
		while(buf<end)
		{
			c = crc32_table[(c ^ *buf++) & 0xff] ^ (c >> 8);
		}
		return c;
	}
	// Return the CRC of the bytes buf[0..len-1].




/* unsigned int update_crc32(unsigned int crc, unsigned char *buf, unsigned int len)
{
    unsigned int        result;//=crc;
    unsigned int        *p = (unsigned int *)buf;
    unsigned int        *e = (unsigned int *)(buf + len);

    if (len < 4) abort();

    result = ~*p++;

    while( p<e )
    {
        result = crc32_table[result & 0xff] ^ result >> 8;
        result = crc32_table[result & 0xff] ^ result >> 8;
        result = crc32_table[result & 0xff] ^ result >> 8;
        result = crc32_table[result & 0xff] ^ result >> 8;
        result ^= *p++;
    }
	//printf("%u\n", result);
    return ~result;
} */

	unsigned int crc32( unsigned char* buf, unsigned int len)
	{
		return ~update_crc32(0xffffffff, buf, len);// ^ 0xffffffff;
	}
