#include <sha1.h>
#include <ST7735.h>
#include <SPI.h>


/* Pin assignments.
   1: Serial input for use with serial test tool.
   2,3,4: Keypad V-lines.
   5,6,7,8: Keypad H-lines.
   9: Display DC/RS pin
   10: Display CS pin.
   11: Display mois/data pin (Fixed by SPI interface hardware)
   12: Display RS connector.
   13: Display SPI clock pin (Fixed by SPI interface hardware)
   Don't worry about getting the pad lines in the right order,
   There's a string in getnumpad() you can alter to compensate.   
   A-lines all unused.
*/

//Display things.
//#define sclk 13  //Fixed by hardware
//#define mosi 11  //Fixed by hardware
#define cs 10
#define dc 9 //aka rs
#define rst 12 //Wish I could ignore this one.
//Remember 2-8 are used for the input.
//  ST7735 tft = ST7735(cs, dc, mosi, sclk, rst);  
  #include "Arduino.h"
void setup();
void loop();
char getnumpad();
ST7735 tft = ST7735(cs, dc, rst);  

void setup(){
  pinMode(2, OUTPUT);
  pinMode(3, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(5, INPUT);digitalWrite(5, HIGH);
  pinMode(6, INPUT);digitalWrite(6, HIGH);
  pinMode(7, INPUT);digitalWrite(7, HIGH);
  pinMode(8, INPUT);digitalWrite(8, HIGH);
  digitalWrite(13, LOW);
  tft.initR();
  tft.writecommand(ST7735_DISPON);
}

void loop(){
  tft.fillScreen(0xF81F);
//  tft.setTextSize(1);
  tft.drawString(0, 0, "Menu:", 0xFFFF);
  tft.drawString(10, 20, "1. Password tool", 0xFFFF);
  tft.drawString(10, 30, "2. Serial debugger", 0xFFFF);
  char menuselect=getnumpad();
  

  if(menuselect=='1')
    function_password();
  if(menuselect=='2')
    function_serial();
}
void function_serial(){
  char outbuffer[3];outbuffer[2]=0;
  int x=0;int y=0;
  Serial.begin(9600);
  tft.fillScreen(0x0000);
 do{
   do{}while(Serial.available()==0);
   char nextbyte=Serial.read();
//   Serial.println(nextbyte);
   outbuffer[1]=(nextbyte&0x0F)+48;
   outbuffer[0]=((nextbyte&0xF0)>>4)+48;
   if(outbuffer[0]>57)
     outbuffer[0]+=7;
   if(outbuffer[1]>57)
     outbuffer[1]+=7;
   tft.drawString(x*15, y*10, outbuffer, 0xFFFF);
   outbuffer[1]=0;outbuffer[0]=nextbyte;
   tft.drawString(90+(x*8), y*10, outbuffer, 0xFFFF);
   
   x++;
   if(x>4){
     x=0;
     y++;
     if(y>14){
       tft.fillScreen(0x0000);
       y=0;
     }
   }
 }while(1);
}
void function_password(){
  unsigned int count=0;
  char buffer[128];
  uint8_t *outbuffer;
  char outstring[9];
  outstring[8]=0;
  password_clear:
  for(count=0;count<128;count++)
    buffer[count]=0;
  count=0;
  tft.fillScreen(0x0000);

  do{
    buffer[count]=getnumpad();
    if(buffer[count]=='*')
      return;
//      goto password_clear; //The evil instruction! But using it here saves a few bytes of instruction, and memory is precious.
    count++;
//    Serial.println(buffer);
    Sha1.init();
    Sha1.println(buffer);
    outbuffer=Sha1.result();
    for(int c=0;c<20;c++){
      outbuffer[c]=(outbuffer[c]&0x3F)+48;
      if(outbuffer[c]>=58)
        outbuffer[c]+=6;
      if(outbuffer[c]>=91)
        outbuffer[c]+=3;
      if(outbuffer[c]>=96)
        outbuffer[c]++;
    }
//    Serial.print("\n");
    for(int c=0;c<8;c++){
      outstring[c]=(char)outbuffer[c];
//      Serial.print(outstring[c]);
    }
//    Serial.print("\n");
//    Serial.print((char *)outbuffer);
  rect(30,20,110,30);
  tft.drawString(30, 20, outstring, 0xFFFF);
  tft.drawString(20, 40, "     ABC  DEF", 0xFFFF);
  tft.drawString(20, 60, "GHI  JKL  MNO", 0xFFFF);
  tft.drawString(20, 80, "PQRS TUV WXYZ", 0xFFFF);

  }while(count<128);

}

void rect(uint8_t x,uint8_t y,uint8_t w,uint8_t h) {
  for (uint8_t a=x; a < w; a++) {
    for (uint8_t b=y; b < h; b++) {
      tft.drawPixel(a, b, 0x000);
    }
  }
}

char getnumpad(){
  //1. Bring all V-lines low.
  //2. Wait until all H-lines are high. Ie, no buttons pressed.
  char row=0;
  char col;
  static char map[]="#396*1740285"; //Adjust according to wiring.
  do{
    digitalWrite(2, LOW);digitalWrite(3, LOW);digitalWrite(4, LOW);
    delay(2);
    do{
    }while(!(digitalRead(5)&&digitalRead(6)&&digitalRead(7)&&digitalRead(8)));
    delay(2);
    do{
      if(!digitalRead(5))
        row=5;
      if(!digitalRead(6))
        row=6;
      if(!digitalRead(7))
        row=7;
      if(!digitalRead(8))
        row=8;
    }while(!row);

    digitalWrite(2, HIGH);
    if(digitalRead(row))
      break;
    digitalWrite(3, HIGH);
    if(digitalRead(row)){
      row+=4;break;}
    digitalWrite(4, HIGH);
    if(digitalRead(row)){
      row+=8;break;}
  }while(1); //Something went horribly wrong. Try again.

  return(map[row-5]);
}


